<?php
// Debug test to check for syntax errors

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Starting debug test...\n";

// Test 1: Check if files exist
$files_to_check = [
    'geo-local-seo-lead-pages-generator.php',
    'includes/class-admin.php',
    'includes/class-database.php',
    'includes/class-frontend.php',
    'includes/class-shortcodes.php'
];

foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        echo "✓ $file exists\n";
    } else {
        echo "✗ $file missing\n";
    }
}

// Test 2: Check for syntax errors in main files
$main_files = [
    'geo-local-seo-lead-pages-generator.php',
    'includes/class-admin.php'
];

foreach ($main_files as $file) {
    if (file_exists($file)) {
        $output = shell_exec("php -l $file 2>&1");
        if (strpos($output, 'No syntax errors') !== false) {
            echo "✓ $file syntax OK\n";
        } else {
            echo "✗ $file syntax error: $output\n";
        }
    }
}

echo "Debug test completed.\n";
?>
