# GEO - Local SEO - Lead Pages Generator

Een krachtige WordPress plugin voor het automatisch genereren van SEO-geoptimaliseerde landingspagina's voor lokale diensten en locaties. Speciaal ontwikkeld voor lokale SEO optimalisatie en lead generatie.

## 🚀 Functies

### ✨ Hoofdfuncties
- **Template Maker**: Maak aangepaste templates voor landingspagina's
- **Locations Manager**: Beheer alle locaties en hun details
- **Shortcode Settings**: Configureer standaard content en contact gegevens
- **Page Generator**: Genereer automatisch landingspagina's met custom URL structures
- **Custom URL Slugs**: Volledige controle over pagina URL's met live preview
- **Leads Management**: Beheer alle binnenkomende leads
- **Analytics**: Uitgebreide rapportages en grafieken
- **SEO Overview**: SEO optimalisatie en monitoring

### 🎯 SEO Features
- Automatische meta tags generatie
- Focus keyword optimalisatie
- Structured data (JSON-LD)
- Open Graph tags
- Yoast SEO integratie
- Sitemap generatie

### 📊 Analytics & Rapportages
- Lead conversie tracking
- Pagina bezoeken statistieken
- Locatie-specifieke rapportages
- Export functionaliteit (CSV)
- Real-time dashboards

## 📦 Installatie

1. **Download** de plugin bestanden
2. **Upload** naar `/wp-content/plugins/seo-lead-pages-generator/`
3. **Activeer** de plugin via het WordPress admin panel
4. **Configureer** de basis instellingen

## ⚙️ Configuratie

### Basis Instellingen
Ga naar **SEO Lead Pages > Settings** en configureer:
- Telefoonnummer voor lead forms
- Contact email adres
- Standaard templates

### Database Tabellen
De plugin maakt automatisch de volgende tabellen aan:
- `wp_seo_lead_pages_services` - Diensten
- `wp_seo_lead_pages_locations` - Locaties
- `wp_seo_lead_pages_leads` - Leads
- `wp_seo_lead_pages_page_views` - Pagina bezoeken

## 🔗 Custom URL Slug Templates

### Volledige Controle over Je URLs
Met de nieuwe URL slug functionaliteit kun je volledig bepalen hoe je pagina URLs worden opgebouwd:

#### Predefined Templates
- **Service in Location**: `seo-diensten-in-amsterdam`
- **Service Location**: `seo-diensten-amsterdam`
- **Location Service**: `amsterdam-seo-diensten`
- **Service in Location, Province**: `seo-diensten-in-amsterdam-noord-holland`
- **Service in Location, Country**: `seo-diensten-in-amsterdam-nederland`

#### Custom Templates
Maak je eigen URL structuur met variabelen:
- `[service_name]` - Je dienst naam
- `[location_name]` - Locatie naam
- `[province_name]` - Provincie naam
- `[business_name]` - Bedrijfsnaam
- `[country]` - Land naam

#### Voorbeelden van Custom Templates
```
[service_name]-[location_name] → seo-diensten-amsterdam
[location_name]-[service_name] → amsterdam-seo-diensten
professionele-[service_name]-in-[location_name] → professionele-seo-diensten-in-amsterdam
[business_name]-[service_name]-[location_name] → uw-bedrijf-seo-diensten-amsterdam
```

### Hoe te Gebruiken
1. Ga naar **Page Generator**
2. Selecteer **"🎨 Custom Template"** in URL Structure
3. Type je gewenste structuur in het custom veld
4. Zie live preview van je URL
5. Genereer je pagina's

## ⚙️ Shortcode Settings

### Gecentraliseerde Content Management
Configureer standaard waarden voor al je pagina's:

- **Service Name**: Je standaard dienst naam
- **Business Name**: Je bedrijfsnaam
- **Phone Number**: Telefoonnummer
- **Contact Email**: Email adres
- **Website URL**: Website URL

### Prioriteit Systeem
1. **Location-specifieke data** (als beschikbaar)
2. **Shortcode Settings** (jouw defaults)
3. **Plugin defaults** (fallback)

## 🎨 Template Maker

### Beschikbare Shortcodes
- `[service_name]` - Naam van de dienst
- `[location_name]` - Naam van de locatie
- `[province_name]` - Naam van de provincie
- `[population]` - Aantal inwoners
- `[landmarks]` - Bezienswaardigheden
- `[phone_number]` - Telefoonnummer uit instellingen
- `[contact_email]` - Email uit instellingen
- `[contact_form]` - Contactformulier
- `[cta_button text="Tekst" style="primary|secondary"]` - Call-to-action knop

### Voorbeeld Template
```html
<div class="landing-page-template">
    <header class="hero-section">
        <h1>[service_name] in [location_name]</h1>
        <p>Professionele [service_name] diensten in [location_name], [province_name]</p>
        <div class="cta-buttons">
            [cta_button text="Gratis Offerte" style="primary"]
            [cta_button text="Bel Ons" style="secondary"]
        </div>
    </header>
    
    <section class="service-description">
        <h2>Waarom kiezen voor onze [service_name] diensten?</h2>
        <p>Wij zijn gespecialiseerd in [service_name] in [location_name] en omgeving.</p>
    </section>
    
    <section class="contact-section">
        [contact_form]
    </section>
</div>
```

## 📍 Locations Manager

Beheer alle locaties en hun details:
- **Naam**: Locatie naam
- **Provincie**: Provincie waar de locatie zich bevindt
- **Land**: Land (standaard: Netherlands)
- **Inwoners**: Aantal inwoners
- **Bezienswaardigheden**: Bekende bezienswaardigheden
- **Coördinaten**: Latitude en longitude (optioneel)

## 🔧 Generator

Genereer automatisch landingspagina's:
1. Selecteer een dienst
2. Selecteer een locatie
3. Kies een template (optioneel)
4. Klik op "Landingspagina Genereren"
5. Bewerk en publiceer de gegenereerde pagina

## 📊 Analytics

### Dashboard Statistieken
- Totaal aantal leads
- Leads deze maand
- Totaal aantal locaties
- Totaal aantal pagina bezoeken
- Conversie percentage

### Grafieken
- Leads per maand (lijn grafiek)
- Leads per locatie (taart grafiek)
- Leads per dienst (staaf grafiek)
- Pagina prestaties (staaf grafiek)
- Conversie funnel (taart grafiek)

### Export Functionaliteit
- Export leads naar CSV
- Export pagina bezoeken naar CSV
- Configureerbare datum bereiken

## 🎯 SEO Features

### Meta Tags
- Automatische meta title generatie
- Automatische meta description generatie
- Focus keyword ondersteuning
- Yoast SEO integratie

### Structured Data
- JSON-LD schema markup
- LocalBusiness schema
- Open Graph tags
- Social media optimalisatie

## 📱 Frontend

### Lead Forms
- Responsive design
- Real-time validatie
- AJAX form submission
- Telefoonnummer formatting
- Email validatie

### Templates
- Modern design
- Classic layout
- Minimal design
- Local focus template
- Aangepaste templates

## 🛠️ Technische Details

### Bestandsstructuur
```
seo-lead-pages-generator/
├── seo-lead-pages-generator-standalone.php
├── includes/
│   ├── class-admin.php
│   ├── class-frontend.php
│   ├── class-database.php
│   ├── class-shortcodes.php
│   ├── class-seo-manager.php
│   ├── class-analytics.php
│   ├── class-template-manager.php
│   ├── class-google-my-business.php
│   └── class-design-manager.php
├── css/
│   ├── admin.css
│   └── frontend.css
└── js/
    ├── admin.js
    ├── frontend.js
    └── analytics.js
```

### Vereisten
- WordPress 5.0+
- PHP 7.4+
- MySQL 5.6+
- jQuery (WordPress standaard)

### Hooks & Filters
De plugin biedt verschillende hooks en filters voor ontwikkelaars:
- `seo_lead_pages_before_lead_submission`
- `seo_lead_pages_after_lead_submission`
- `seo_lead_pages_template_data`
- `seo_lead_pages_analytics_data`

## 🔒 Beveiliging

- WordPress nonce verificatie
- Capability checks
- Input sanitization
- SQL injection bescherming
- XSS bescherming

## 📈 Performance

- Database optimalisatie
- Caching ondersteuning
- Lazy loading
- Minified assets
- CDN ready

## 🌐 Internationalisatie

- Nederlandse taal standaard
- Gettext ondersteuning
- RTL taal ondersteuning
- Lokale datum/tijd formatting

## 🆘 Support

### Documentatie
- Uitgebreide inline documentatie
- Code comments
- Voorbeeld templates
- Best practices

### Troubleshooting
1. Controleer WordPress debug log
2. Verifieer database tabellen
3. Test shortcodes
4. Controleer bestandsrechten

## 🔄 Updates

### Automatische Updates
- WordPress update systeem integratie
- Versie controle
- Database migraties
- Backward compatibility

### Changelog
- **v1.0.0**: Initiële release
  - Template Maker
  - Locations Manager
  - Analytics Dashboard
  - SEO optimalisatie
  - Lead management

## 📄 Licentie

GPL v2 of later - Zie [LICENSE](LICENSE) bestand voor details.

## 👥 Bijdragen

Bijdragen zijn welkom! Zie [CONTRIBUTING.md](CONTRIBUTING.md) voor richtlijnen.

## 🏷️ Credits

Ontwikkeld door [Storm SEO](https://stormseo.nl)

---

**Let op**: Deze plugin is ontworpen voor professioneel gebruik. Test altijd in een staging omgeving voordat je deze in productie gebruikt.
