# Installatie Handleiding - SEO Lead Pages Generator

## 📋 Vereisten

Voordat je begint, zorg ervoor dat je WordPress installatie voldoet aan de volgende vereisten:

- **WordPress**: Versie 5.0 of hoger
- **PHP**: Versie 7.4 of hoger
- **MySQL**: Versie 5.6 of hoger
- **Berechtigingen**: Schrijfrechten voor de `/wp-content/plugins/` map

## 🚀 Stap-voor-Stap Installatie

### Stap 1: Download de Plugin
1. Download alle plugin bestanden
2. Zorg ervoor dat de bestandsstructuur intact blijft

### Stap 2: Upload naar WordPress
1. Log in op je WordPress admin panel
2. Ga naar **Plugins > Nieuwe plugin toevoegen**
3. Klik op **Plugin uploaden**
4. Sleep alle plugin bestanden naar de uploader
5. Klik op **Nu installeren**

### Stap 3: Activeer de Plugin
1. Na succesvolle installatie, klik op **Plugin activeren**
2. Je ziet nu een nieuwe menu-item **"SEO Lead Pages"** in je admin menu

### Stap 4: Eerste Configuratie
1. Ga naar **SEO Lead Pages > Settings**
2. Vul je telefoonnummer in
3. Controleer je contact email adres
4. Klik op **Instellingen Opslaan**

## ⚙️ Basis Configuratie

### Database Tabellen
De plugin maakt automatisch de benodigde database tabellen aan bij activatie. Je hoeft hier niets handmatig te doen.

### Standaard Instellingen
- **Telefoonnummer**: Wordt gebruikt in lead forms en op landingspagina's
- **Contact Email**: Email adres waar nieuwe leads naartoe worden gestuurd
- **Templates**: Standaard templates zijn al beschikbaar

## 🎯 Eerste Gebruik

### 1. Template Maker
1. Ga naar **SEO Lead Pages > Template Maker**
2. Maak je eerste aangepaste template
3. Gebruik de beschikbare shortcodes

### 2. Locations Manager
1. Ga naar **SEO Lead Pages > Locations Manager**
2. Voeg je eerste locatie toe
3. Vul inwoners en bezienswaardigheden in

### 3. Generator
1. Ga naar **SEO Lead Pages > Generator**
2. Selecteer een dienst en locatie
3. Genereer je eerste landingspagina

## 🔧 Probleemoplossing

### Veelvoorkomende Problemen

#### Plugin wordt niet geactiveerd
- Controleer of alle bestanden correct zijn geüpload
- Controleer PHP versie (moet 7.4+ zijn)
- Controleer WordPress versie (moet 5.0+ zijn)

#### Database tabellen worden niet aangemaakt
- Controleer database rechten
- Controleer WordPress debug log
- Probeer de plugin opnieuw te activeren

#### Menu items verschijnen niet
- Controleer of je administrator rechten hebt
- Controleer of de plugin correct is geactiveerd
- Probeer je browser cache te legen

#### Shortcodes werken niet
- Controleer of de shortcode class correct is geladen
- Controleer of er geen JavaScript fouten zijn
- Test in een nieuwe pagina/post

### Debug Modus
Als je problemen ondervindt, activeer WordPress debug modus:

1. Voeg toe aan `wp-config.php`:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);
```

2. Controleer de debug log in `/wp-content/debug.log`

## 📞 Support

Als je problemen ondervindt die niet in deze handleiding worden behandeld:

1. Controleer de [README.md](README.md) voor uitgebreide documentatie
2. Controleer de WordPress debug log
3. Test in een staging omgeving
4. Neem contact op via [Storm SEO](https://stormseo.nl)

## ✅ Installatie Controle

Na installatie zou je het volgende moeten zien:

- ✅ Menu-item "SEO Lead Pages" in admin menu
- ✅ Alle submenu pagina's toegankelijk
- ✅ Database tabellen aangemaakt
- ✅ Basis instellingen configureerbaar
- ✅ Template Maker functionaliteit
- ✅ Locations Manager functionaliteit
- ✅ Generator functionaliteit

## 🎉 Gefeliciteerd!

Je hebt de SEO Lead Pages Generator succesvol geïnstalleerd! Je kunt nu beginnen met het maken van SEO-geoptimaliseerde landingspagina's voor je diensten en locaties.

---

**Tip**: Begin met het maken van een eenvoudige template en test deze op een testlocatie voordat je alle functionaliteiten gebruikt.
